/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import java.util.List;
import java.util.Set;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRPlayerData;
import lotr.common.LOTRPotions;
import lotr.common.fac.LOTRFaction;
import lotr.common.item.LOTRItemSword;
import lotr.common.item.LOTRMaterial;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.EnumDifficulty;

public class LOTRItemDagger
extends LOTRItemSword {
    private DaggerEffect effect;

    public LOTRItemDagger(LOTRMaterial material) {
        this(material, DaggerEffect.NONE);
    }

    public LOTRItemDagger(Item.ToolMaterial material) {
        this(material, DaggerEffect.NONE);
    }

    public LOTRItemDagger(LOTRMaterial material, DaggerEffect e) {
        this(material.toToolMaterial(), e);
    }

    public LOTRItemDagger(Item.ToolMaterial material, DaggerEffect e) {
        super(material);
        this.lotrWeaponDamage -= 3.0f;
        this.effect = e;
    }

    public DaggerEffect getDaggerEffect() {
        return this.effect;
    }

    @Override
    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase hitEntity, EntityLivingBase user) {
        itemstack.func_77972_a(1, user);
        if (this.effect == DaggerEffect.NONE) {
            return true;
        }
        if (this.effect == DaggerEffect.POISON) {
            LOTRItemDagger.applyStandardPoison(hitEntity);
        }
        if (this.effect == DaggerEffect.WITHER) {
            LOTRItemDagger.applyStandardPoison1(hitEntity);
        }
        if (this.effect == DaggerEffect.WEAK) {
            LOTRItemDagger.applyStandardWeak(hitEntity);
        }
        if (this.effect == DaggerEffect.SLOWNESS) {
            LOTRItemDagger.applyStandardSlow(hitEntity);
        }
        if (this.effect == DaggerEffect.SLOWNESSM) {
            LOTRItemDagger.applyStandardSlow1(hitEntity);
        }
        if (this.effect == DaggerEffect.HUNGER) {
            LOTRItemDagger.applyStandardHunger(hitEntity);
        }
        if (this.effect == DaggerEffect.BLOOD) {
            LOTRItemDagger.applyStandardBlood(hitEntity);
        }
        if (this.effect == DaggerEffect.BLOOD1) {
            LOTRItemDagger.applyStandardBlood1(hitEntity);
        }
        if (this.effect == DaggerEffect.EXPLOSION) {
            LOTRItemDagger.applyStandardExplosion(hitEntity);
        }
        return true;
    }

    private LOTRFaction.FactionType getPriorityFactionType(Set<LOTRFaction.FactionType> factionTypes) {
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_ELF)) {
            return LOTRFaction.FactionType.TYPE_ELF;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_DWARF)) {
            return LOTRFaction.FactionType.TYPE_DWARF;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_TREE)) {
            return LOTRFaction.FactionType.TYPE_TREE;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_MAN)) {
            return LOTRFaction.FactionType.TYPE_MAN;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_ORC)) {
            return LOTRFaction.FactionType.TYPE_ORC;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_TROLL)) {
            return LOTRFaction.FactionType.TYPE_TROLL;
        }
        return LOTRFaction.FactionType.TYPE_FREE;
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        if (player != null) {
            String factionName;
            int reputation;
            LOTRPlayerData playerData = LOTRLevelData.getData(player);
            LOTRFaction pledgeFaction = playerData.getPledgeFaction();
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_TREE) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                if (reputation < 10000) {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 10000}));
                } else if (reputation >= 10000 && reputation < 15000) {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 20000}));
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.entDamage.active", (Object[])new Object[]{"3.0"}));
                } else if (reputation >= 20000) {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.active", (Object[])new Object[]{"2.0"}));
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.entDamage.active", (Object[])new Object[]{"3.0"}));
                }
            }
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_TROLL) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                list.add(EnumChatFormatting.GREEN + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                if (reputation < 20000) {
                    list.add("");
                    list.add(EnumChatFormatting.GREEN + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 20000}));
                } else {
                    list.add("");
                    list.add(EnumChatFormatting.GREEN + "\u2694 " + I18n.func_135052_a((String)"item.hammer.trollDamage.active", (Object[])new Object[]{"2.0"}));
                }
            }
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_DWARF) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                if (reputation < 10000) {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 10000}));
                } else {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.dwarfDamage.active", (Object[])new Object[]{"2.0"}));
                }
            }
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_MAN) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                if (reputation < 5000) {
                    list.add(EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.YELLOW + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 5000}));
                } else {
                    list.add(EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.YELLOW + "\u2694 " + I18n.func_135052_a((String)"item.hammer.manDamage.active", (Object[])new Object[]{"3.0"}));
                }
            }
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_ORC) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                if (reputation < 10000) {
                    list.add(EnumChatFormatting.RED + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.RED + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 10000}));
                } else if (reputation >= 10000 && reputation < 15000) {
                    list.add(EnumChatFormatting.RED + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.RED + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 15000}));
                    list.add(EnumChatFormatting.RED + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.active", (Object[])new Object[]{"2.0"}));
                } else if (reputation >= 15000) {
                    list.add(EnumChatFormatting.RED + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.RED + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.active", (Object[])new Object[]{"2.0"}));
                    list.add(EnumChatFormatting.RED + "\u2694 " + I18n.func_135052_a((String)"item.hammer.orcDamage.active", (Object[])new Object[]{"3.0"}));
                }
            }
        }
    }

    public static void applyStandardPoison(EntityLivingBase entity) {
        EnumDifficulty difficulty = entity.field_70170_p.field_73013_u;
        int duration = 1 + difficulty.func_151525_a() * 2;
        PotionEffect poison = new PotionEffect(Potion.field_76436_u.field_76415_H, (duration + field_77697_d.nextInt(duration)) * 20);
        entity.func_70690_d(poison);
    }

    public static void applyStandardDrunk(EntityLivingBase entity) {
        EnumDifficulty difficulty = entity.field_70170_p.field_73013_u;
        int duration = 1 + difficulty.func_151525_a() * 2;
        PotionEffect poison = new PotionEffect(LOTRPotions.drunk.field_76415_H, (duration + field_77697_d.nextInt(duration)) * 20);
        entity.func_70690_d(poison);
        PotionEffect nausea = new PotionEffect(Potion.field_76431_k.field_76415_H, (duration + field_77697_d.nextInt(duration)) * 20, 10);
        entity.func_70690_d(nausea);
        PotionEffect slowness = new PotionEffect(Potion.field_76421_d.field_76415_H, (duration + field_77697_d.nextInt(duration)) * 20, 1);
        entity.func_70690_d(slowness);
    }

    public static void applyStandardPoison1(EntityLivingBase entity) {
        EnumDifficulty difficulty = entity.field_70170_p.field_73013_u;
        int duration = 1 + difficulty.func_151525_a() * 2;
        PotionEffect poison = new PotionEffect(Potion.field_82731_v.field_76415_H, (duration + field_77697_d.nextInt(duration)) * 20);
        entity.func_70690_d(poison);
    }

    public static void applyStandardSlow(EntityLivingBase entity) {
        EnumDifficulty difficulty = entity.field_70170_p.field_73013_u;
        int duration = 1 + difficulty.func_151525_a() * 2;
        PotionEffect poison1 = new PotionEffect(Potion.field_76421_d.field_76415_H, (duration + field_77697_d.nextInt(duration)) * 20);
        entity.func_70690_d(poison1);
    }

    public static void applyStandardSlow1(EntityLivingBase entity) {
        EnumDifficulty difficulty = entity.field_70170_p.field_73013_u;
        int duration = 1 + difficulty.func_151525_a() * 2;
        PotionEffect poison1 = new PotionEffect(Potion.field_76421_d.field_76415_H, (duration + field_77697_d.nextInt(duration)) * 20);
        PotionEffect poison2 = new PotionEffect(Potion.field_76436_u.field_76415_H, (duration + field_77697_d.nextInt(duration)) * 20);
        entity.func_70690_d(poison1);
        entity.func_70690_d(poison2);
    }

    public static void applyStandardWeak(EntityLivingBase entity) {
        EnumDifficulty difficulty = entity.field_70170_p.field_73013_u;
        int duration = 1 + difficulty.func_151525_a() * 2;
        PotionEffect poison2 = new PotionEffect(LOTRPotions.vulnerability.field_76415_H, (duration + field_77697_d.nextInt(duration)) * 40);
        PotionEffect poison21 = new PotionEffect(Potion.field_76437_t.field_76415_H, (duration + field_77697_d.nextInt(duration)) * 20);
        entity.func_70690_d(poison21);
        entity.func_70690_d(poison2);
    }

    public static void applyStandardFall(EntityLivingBase entity) {
        EnumDifficulty difficulty = entity.field_70170_p.field_73013_u;
        int duration = 1 + difficulty.func_151525_a() * 2;
        PotionEffect levitationEffect = new PotionEffect(LOTRPotions.levitation.field_76415_H, 20, 1);
        entity.func_70690_d(levitationEffect);
    }

    public static void applyStandardHunger(EntityLivingBase entity) {
        EnumDifficulty difficulty = entity.field_70170_p.field_73013_u;
        int duration = 8 + difficulty.func_151525_a() * 2;
        PotionEffect hungerEffect = new PotionEffect(Potion.field_76438_s.field_76415_H, (duration + field_77697_d.nextInt(duration)) * 20, 26);
        PotionEffect poison2 = new PotionEffect(LOTRPotions.infection.field_76415_H, (duration + field_77697_d.nextInt(duration)) * 20);
        entity.func_70690_d(hungerEffect);
    }

    public static void applyStandardBlood(EntityLivingBase entity) {
        EnumDifficulty difficulty = entity.field_70170_p.field_73013_u;
        int duration = 4 + difficulty.func_151525_a() * 2;
        int chance = entity.field_70170_p.field_73012_v.nextInt(100);
        if (chance <= 30) {
            PotionEffect bloodEffect = new PotionEffect(LOTRPotions.blood.field_76415_H, (duration + entity.field_70170_p.field_73012_v.nextInt(duration)) * 20, 1);
            entity.func_70690_d(bloodEffect);
        }
    }

    public static void applyStandardBlood1(EntityLivingBase entity) {
        EnumDifficulty difficulty = entity.field_70170_p.field_73013_u;
        int duration = 4 + difficulty.func_151525_a() * 2;
        int chance = entity.field_70170_p.field_73012_v.nextInt(100);
        if (chance <= 30) {
            PotionEffect bloodEffect = new PotionEffect(LOTRPotions.blood.field_76415_H, (duration + entity.field_70170_p.field_73012_v.nextInt(duration)) * 20);
            entity.func_70690_d(bloodEffect);
        }
    }

    public static void applyStandardExplosion(EntityLivingBase entity) {
        EnumDifficulty difficulty = entity.field_70170_p.field_73013_u;
        int duration = 1 + difficulty.func_151525_a() * 2;
        PotionEffect poison4 = new PotionEffect(LOTRPotions.explode.field_76415_H, 0, 0);
        int ticks = 1;
        poison4.func_76452_a(new PotionEffect(LOTRPotions.explode.field_76415_H, ticks));
        entity.func_70690_d(poison4);
    }

    public static enum DaggerEffect {
        NONE,
        POISON,
        BLOOD,
        BLOOD1,
        WITHER,
        SLOWNESS,
        SLOWNESSM,
        WEAK,
        HUNGER,
        EXPLOSION;

    }
}

